package com.esv.superhive.cc.module.menu.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.superhive.cc.module.menu.entity.MenuEntity;
import com.esv.superhive.cc.module.menu.dto.MenuDTO;
import com.esv.superhive.cc.module.menu.dto.SystemMenuDTO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 菜单管理
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-10 15:25:41
 */
@Mapper
public interface MenuDao extends BaseMapper<MenuEntity> {
    /**
     * description 根据用户和租户权限查询可用系统及目录
     * param [tenantId, userId]
     * return java.util.List<SystemMenuDTO>
     * author chenfm
     * createTime 2020/3/12 10:41
     **/
    List<SystemMenuDTO> listSystemMenuTree(Long userId);

    /**
     * description 查询子菜单
     * param [parentId]
     * return java.util.List<MenuDTO>
     * author chenfm
     * createTime 2020/3/12 10:41
     **/
    List<MenuDTO> queryByParentId(@Param("parentId") long parentId, Long userId);

    /**
     * description 根据系统查询菜单
     * param [param]
     * return java.util.List<MenuDTO>
     * author chenfm
     * createTime 2020/3/12 10:42
     **/
    List<MenuDTO> querySystemMenu(Map<String, Object> param);

    /**
     * description 查询系统根菜单
     * param [param]
     * return java.util.List<com.esv.cc.module.menu.dto.MenuDTO>
     * author chenfm
     * createTime 2020/6/24 10:40
     **/
    List<MenuDTO> systemTypeMenu(Map<String, Object> param);

    /**
     * description 查询用户权限
     * param [param]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/12 10:42
     **/
    List<String> queryPermsByUser(Map<String, Object> param);

    List<String> queryMenuCodeByUser(Map<String, Object> param);

}
