package com.esv.superhive.cc.module.menu.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.esv.superhive.cc.common.form.Add;
import com.esv.superhive.cc.common.form.Update;
import com.esv.superhive.cc.form.IdForm;
import com.esv.superhive.cc.module.menu.dto.SystemMenuDTO;
import com.esv.superhive.cc.module.menu.entity.MenuEntity;
import com.esv.superhive.cc.module.menu.form.MenuForm;
import com.esv.superhive.cc.module.menu.service.MenuService;
import com.esv.common.response.R;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 菜单管理
 */
@Slf4j
@RestController
@RequestMapping("menu")
public class MenuController {

    private MenuService menuService;

    @Autowired
    public MenuController(MenuService menuService) {
        this.menuService = menuService;
    }

    /**
     * description 菜单树列表
     * param []
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/12 9:28
     **/
    @GetMapping("listTree")
    public R listTree(@RequestHeader(GatewayHeaders.USER_ID) Long userId) {
        List<SystemMenuDTO> systemMenuDTOList = menuService.listSystemMenuTree(userId);
        return R.ok(systemMenuDTOList);
    }

    @Transactional
    @PostMapping("add")
    public R add(@RequestBody @Validated(Add.class) MenuForm menuForm) {
        String menuCode = menuForm.getMenuCode();
        QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("menu_code", menuCode);
        if (!menuService.list(wrapper).isEmpty()) {
            return R.error("该菜单编码已存在");
        }
        menuService.saveOrUpdate(menuForm);
        return R.ok();
    }

    @PostMapping("update")
    public R update(@RequestBody @Validated(Update.class) MenuForm menuForm) {
        String menuCode = menuForm.getMenuCode();
        if (StringUtils.isNotBlank(menuCode)) {
            QueryWrapper<MenuEntity> wrapper = new QueryWrapper<>();
            wrapper.ne("id", menuForm.getId());
            wrapper.eq("menu_code", menuCode);
            if (menuService.count(wrapper) != 0) {
                return R.error("该菜单编码已存在");
            }
        }
        menuService.saveOrUpdate(menuForm);
        return R.ok();
    }

    @PostMapping("delete")
    public R delete(@RequestBody @Validated IdForm idForm) {
        Long id = idForm.getId();
        menuService.removeMenuTree(id);
        return R.ok();
    }

}
