package com.esv.superhive.cc.module.department.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.superhive.cc.module.department.dto.DepartmentDTO;
import com.esv.superhive.cc.module.department.entity.DepartmentEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 部门表
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Mapper
public interface DepartmentDao extends BaseMapper<DepartmentEntity> {

    /**
     * description 根据上级id查询部门列表
     * param [tenantId, parentId, departmentName]
     * return java.util.List<com.esv.cc.module.department.dto.DepartmentDTO>
     * author chenfm
     * createTime 2020/4/1 11:27
     **/
    List<DepartmentDTO> selectByParentId(long tenantId, Long parentId, String departmentName);

}
