package com.esv.superhive.cc.module.authentication.service.impl;

import com.esv.superhive.cc.common.constants.ApiResponseCode;
import com.esv.superhive.cc.module.account.bo.TokenBO;
import com.esv.superhive.cc.module.authentication.service.AuthenticationService;
import com.esv.superhive.cc.module.department.service.DepartmentService;
import com.esv.superhive.cc.module.menu.service.MenuService;
import com.esv.superhive.cc.module.role.service.RoleMenuService;
import com.esv.superhive.cc.module.system.entity.SystemEntity;
import com.esv.superhive.cc.module.system.service.SystemService;
import com.esv.superhive.cc.module.user.entity.UserEntity;
import com.esv.superhive.cc.module.user.service.UserRoleService;
import com.esv.superhive.cc.module.user.service.UserService;
import com.esv.superhive.cc.util.RequestUriUtils;
import com.esv.common.response.EResponse;
import com.esv.feign.cc.res.WebReqAuthRes;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Service("authenticationService")
@Slf4j
public class AuthenticationServiceImpl implements AuthenticationService {

    private SystemService systemService;

    private UserService userService;

    private UserRoleService userRoleService;

    private RoleMenuService roleMenuService;

    private MenuService menuService;

    private DepartmentService departmentService;

    @Autowired
    public AuthenticationServiceImpl(SystemService systemService, UserService userService,
                                     UserRoleService userRoleService, RoleMenuService roleMenuService,
                                     MenuService menuService, DepartmentService departmentService) {
        this.systemService = systemService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.roleMenuService = roleMenuService;
        this.menuService = menuService;
        this.departmentService = departmentService;
    }

    @Override
    public EResponse<WebReqAuthRes> access(WebReqAuthRes webReqAuthRes, String menuCode, String url) {
        Long userId = webReqAuthRes.getUserId();
        if (log.isDebugEnabled()) {
            log.debug("用户鉴权开始 -- UserId:{}, MenuCode:{}, Url:{}", userId, menuCode, url);
        }
        if (userRoleService.hasSuperAdminRole(userId)) {
            if (log.isDebugEnabled()) {
                log.debug("用户拥有超级管理员角色, 数据权限类型:{}", webReqAuthRes.getDataPerm());
            }
            return EResponse.ok(webReqAuthRes);
        }

        /** 取消根据应用进行鉴权 黄朝斌 2020/06/28 **/
//        SystemEntity entity = systemService.getByCode(RequestUriUtils.getSystemCode(url));
//        if (entity == null) {
//            log.info("鉴权失败, 应用不存在");
//            return EResponse.error(ApiResponseCode.SYSTEM_NOT_FOUND);
//        }
        /** 取消根据应用进行鉴权 黄朝斌 2020/06/28 **/

        Set<String> userPermSet = menuService.userPermSet(null, userId, null);
        String permStr = RequestUriUtils.getPermsUrl(url);
        if (!userPermSet.contains(permStr)) {
            if (log.isDebugEnabled()) {
                log.debug("鉴权失败, 用户没有该权限");
            }
            return EResponse.error(ApiResponseCode.NO_AUTHORITY);
        }

        Integer dataPerm = roleMenuService.findUserMenuCodeDataPerm(userId, menuCode);
        // todo 前端请求中添加menuCode之后删除此段代码, 目前默认租户权限
        if (dataPerm == null) {
            dataPerm = 1;
        }

        // 如果是部门权限需要将下属部门全部列出
        if (dataPerm == 2) {
            // 部门id为0表示该组织就是租户, 与租户权限相同
            if (webReqAuthRes.getDepartmentId() == 0L) {
                dataPerm = 1;
            }
            List<Long> departmentIdList = new ArrayList<>();
            departmentService.findCurrentAndChildrenId(departmentIdList, webReqAuthRes.getDepartmentId());
            String departmentChildren = StringUtils.join(departmentIdList, ",");
            webReqAuthRes.setDepartmentChildren(departmentChildren);
        }
        webReqAuthRes.setDataPerm(dataPerm);
        if (log.isDebugEnabled()) {
            log.debug("鉴权成功, 数据权限类型:{}", dataPerm);
        }
        return EResponse.ok(webReqAuthRes);
    }

    @Override
    public void setTokenDataPerm(TokenBO tokenBO, WebReqAuthRes webReqAuthRes) {
        int type = tokenBO.getType();
        if (0 == type) {
            webReqAuthRes.setDataPerm(0);
        } else if (1 == type) {
            webReqAuthRes.setDataPerm(1);
        } else {
            // 部门id为0表示该组织就是租户, 与租户权限相同
            if (webReqAuthRes.getDepartmentId() == 0L) {
                webReqAuthRes.setDataPerm(1);
            } else {
                webReqAuthRes.setDataPerm(2);
                List<Long> departmentIdList = new ArrayList<>();
                departmentService.findCurrentAndChildrenId(departmentIdList, webReqAuthRes.getDepartmentId());
                String departmentChildren = StringUtils.join(departmentIdList, ",");
                webReqAuthRes.setDepartmentChildren(departmentChildren);
            }
        }
    }

    @Override
    public boolean isAllowAccess(long userId, String url) {
        if (log.isDebugEnabled()) {
            log.debug("鉴权开始 -- UserId:{}, Url:{}", userId, url);
        }
        Preconditions.checkArgument(StringUtils.isNotBlank(url));
        if (userRoleService.hasSuperAdminRole(userId)) {
            return true;
        }

        UserEntity userEntity = userService.getById(userId);
        if (userEntity == null) {
            log.warn("指定Id不存在，权限验证失败! userId: {}", userId);
            return false;
        }
        if (userEntity.getStatus() == null || userEntity.getStatus() == 0) {
            log.warn("指定用户已被锁定，权限验证失败! userId: {}", userId);
            return false;
        }

        SystemEntity entity = systemService.getByCode(RequestUriUtils.getSystemCode(url));
        if (entity == null) {
            log.error("应用不存在");
            return false;
        }
        Set<String> userPermSet = menuService.userPermSet(entity.getId(), userId, null);
        String permStr = RequestUriUtils.getPermsUrl(url);
        boolean result = userPermSet.contains(permStr);
        if (log.isDebugEnabled()) {
            log.debug("鉴权结果 -- {}", result);
        }
        return result;
    }

    @Override
    public void updateCacheByUserId(long userId) {

    }

    @Override
    public void updateCacheByRoleId(long roleId) {

    }

    @Override
    public void updateCacheByMenuId(long menuId) {

    }

    /**
     * 通过userId来清空缓存
     * @param userId 用户Id
     */
//    @CacheEvict(value= CACHE_NAME_SPACE, key= CACHE_KEY)
    public void clearCacheByUserId(long userId) {
        // nothing
    }

    /**
     * 通过userId检索该用户可以访问的Url
     * @param userId 用户Id
     * @return 权限Map，key -> url， value：menuId
     */
    /*
    @Cacheable(cacheNames = "userPerm", key = ("#root.args[0]" + "_" + "#root.args[1]"))
    public Set<String> userPermSet(long systemId, long userId) {
        List<String> permsList = menuService.listUserPerms(systemId, userId);
        Set<String> permSet = new HashSet<>();
        for (String perms : permsList) {
            if (StringUtils.isNotBlank(perms)) {
                permSet.addAll(Arrays.asList(perms.split(";")));
            }
        }
        return permSet;
    }
     */

    /**
     * 过滤掉字符串前后的 '/'
     */
    public String filterUrl(String url) {
        int len = url.length();
        int st = 0;
        char[] val = url.toCharArray();

        while ((st < len) && (val[st] == '/')) {
            st++;
        }
        while ((st < len) && (val[len - 1] == '/')) {
            len--;
        }
        return ((st > 0) || (len < url.length())) ? url.substring(st, len) : url;
    }

}
