package com.esv.superhive.cc.common.component;

import com.esv.superhive.cc.util.EncryptUtils;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * 账号密码组件
 */
@Component
public class AccountPasswordComponent {

    /**
     * 创建简单密码加密盐
     * @return
     */
    public String getSimpleSalt() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * 生成DB存储的密码
     * @param pwd 明文密码MD5加密后的密码
     * @param salt
     * @return
     */
    public String generatePasswordDB(String pwd, String salt) {
        return EncryptUtils.md5(pwd + salt);
    }

}
