package com.esv.superhive.cc.module.user.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.util.Date;

/**
 * @description:
 * @project: esv-cc
 * @name: com.esv.cc.module.user.vo.UserInfoVO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/8 19:40
 * @version:1.0
 */
@Data
public class UserInfoVO {
    /**
     * 用户id
     */
    @TableId
    private Long id;
    /**
     * 用户名
     */
    private String account;
    /**
     * 姓名
     */
    private String realName;

    /**
     * 邮箱
     */
    private String email;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 状态  0：禁用   1：正常
     */
    private Integer status;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 所属部门id
     */
    private Long departmentId;
    /**
     * 职位
     */
    private String position;
    /**
     * 创建用户
     */
    @TableField(fill = FieldFill.INSERT)
    private String createUser;
    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新用户
     */
    @TableField(fill = FieldFill.UPDATE)
    private String updateUser;
    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.UPDATE)
    private Date updateTime;
}
