package com.esv.superhive.cc.module.system.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.superhive.cc.module.account.dto.UserSystemDTO;
import com.esv.superhive.cc.module.system.dto.SystemDTO;
import com.esv.superhive.cc.module.system.entity.SystemEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;
import java.util.Map;

/**
 * 系统应用表
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Mapper
public interface SystemDao extends BaseMapper<SystemEntity> {

    /**
     * description 分页查询系统信息
     * param [page, param]
     * return com.baomidou.mybatisplus.core.metadata.IPage<com.esv.cc.module.system.dto.SystemDTO>
     * author chenfm
     * createTime 2020/4/1 9:57
     **/
    IPage<SystemDTO> page(IPage<SystemDTO> page, Map<String, Object> param);

    /**
     * description 查询租户可用系统
     * param [tenant]
     * return java.util.List<UserSystemDTO>
     * author chenfm
     * createTime 2020/3/13 14:19
     **/
    List<SystemEntity> tenantSystemList(Long tenantId);

    /**
     * description 查询用户可用系统
     * param [userId]
     * return java.util.List<UserSystemDTO>
     * author chenfm
     * createTime 2020/3/13 14:19
     **/
    List<UserSystemDTO> userSystemList(Long userId);
	
}
