package com.esv.superhive.cc.module.role.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.cc.module.role.dao.RoleMenuDao;
import com.esv.superhive.cc.module.role.dto.RowKeyDTO;
import com.esv.superhive.cc.module.role.entity.RoleMenuEntity;
import com.esv.superhive.cc.module.role.service.RoleMenuService;
import com.esv.superhive.cc.module.role.service.RoleService;
import com.esv.superhive.cc.module.role.vo.RoleMenuVO;
import com.esv.superhive.cc.module.role.vo.RowKeyVO;
import com.esv.superhive.cc.module.user.entity.UserRoleEntity;
import com.esv.superhive.cc.module.user.service.UserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

@Service("roleMenuService")
public class RoleMenuServiceImpl extends ServiceImpl<RoleMenuDao, RoleMenuEntity> implements RoleMenuService {

    private RoleService roleService;

    private UserRoleService userRoleService;

    @Autowired
    public RoleMenuServiceImpl(RoleService roleService, UserRoleService userRoleService) {
        this.roleService = roleService;
        this.userRoleService = userRoleService;
    }

    @Override
    public Integer findUserMenuCodeDataPerm(Long userId, String menuCode) {
        Integer dataPerm = null;
        List<UserRoleEntity> userRoleList = userRoleService.listByUserId(userId);
        for (UserRoleEntity userRoleEntity : userRoleList) {
            Long roleId = userRoleEntity.getRoleId();
            if (roleService.isSuperAdminRole(roleId)) {
                return 0;
            }
            List<RoleMenuEntity> roleMenuEntityList = baseMapper.listByRoleIdAndMenuCode(roleId, menuCode);
            for (RoleMenuEntity roleMenuEntity : roleMenuEntityList) {
                if ((roleMenuEntity.getDataPerm() != null) &&
                        (dataPerm == null || roleMenuEntity.getDataPerm() < dataPerm)) {
                    dataPerm = roleMenuEntity.getDataPerm();
                }
            }
        }
        return dataPerm;
    }

    @Override
    public RoleMenuVO queryRoleMenuRowKey(Long roleId) {
        RoleMenuVO roleMenuVO = new RoleMenuVO();
        List<RowKeyVO> rowKeyList = new ArrayList<>();
        if (roleService.isSuperAdminRole(roleId)) {
            List<RowKeyDTO> rowKeyDTOList = baseMapper.queryRoleMenuRowKey(null);
            for (RowKeyDTO rowKeyDTO : rowKeyDTOList) {
                RowKeyVO rowKeyVO = new RowKeyVO(rowKeyDTO.getRowKey());
                if (rowKeyDTO.getType() == 1) {
                    // 管理员赋予全部数据权限
                    rowKeyVO.setDataPerm(0);
                }
                rowKeyList.add(rowKeyVO);
            }
            roleMenuVO.setCanEdited(false);
        } else {
            List<RowKeyDTO> rowKeyDTOList = baseMapper.queryRoleMenuRowKey(roleId);
            for (RowKeyDTO rowKeyDTO : rowKeyDTOList) {
                RowKeyVO rowKeyVO = new RowKeyVO(rowKeyDTO.getRowKey());
                rowKeyVO.setDataPerm(rowKeyDTO.getDataPerm());
                rowKeyList.add(rowKeyVO);
            }
            roleMenuVO.setCanEdited(true);
        }
        roleMenuVO.setRowKeyList(rowKeyList);
        return roleMenuVO;
    }

    @Transactional
    @Override
    public void saveRoleMenu(long roleId, List<RoleMenuEntity> roleMenuEntityList) {
        QueryWrapper<RoleMenuEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("role_id", roleId);
        baseMapper.delete(wrapper);

        List<RoleMenuEntity> list = new ArrayList<>();
        for (RoleMenuEntity roleMenuEntity : roleMenuEntityList) {
            roleMenuEntity.setRoleId(roleId);
            list.add(roleMenuEntity);
        }
        this.saveBatch(list);
    }

    @Override
    public void deleteByMenuId(Long menuId) {
        RoleMenuEntity entity = new RoleMenuEntity();
        entity.setMenuId(menuId);
        remove(new QueryWrapper<>(entity));
    }

}