package com.esv.superhive.cc.module.role.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.cc.module.role.entity.RoleMenuEntity;
import com.esv.superhive.cc.module.role.vo.RoleMenuVO;

import java.util.List;

/**
 * 角色与菜单对应关系
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
public interface RoleMenuService extends IService<RoleMenuEntity> {

    /**
     * description 鉴权时根据用户id和菜单编号查询数据权限
     * param [userId, menuCode]
     * return java.util.List<com.esv.cc.module.role.entity.RoleMenuEntity>
     * author chenfm
     * createTime 2020/4/4 15:33
     **/
    Integer findUserMenuCodeDataPerm(Long userId, String menuCode);

    /**
     * description 查询角色权限
     * param [roleId]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/13 15:20
     **/
    RoleMenuVO queryRoleMenuRowKey(Long roleId);

    /**
     * description 保存角色权限
     * param [roleId, menuList]
     * return void
     * author chenfm
     * createTime 2020/3/13 15:21
     **/
    void saveRoleMenu(long roleId, List<RoleMenuEntity> roleMenuEntityList);

    /**
     * description 根据菜单id删除
     * param [menuId]
     * return void
     * author chenfm
     * createTime 2020/4/8 18:56
     **/
    void deleteByMenuId(Long menuId);

}

