package com.esv.superhive.cc.module.department.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class DepartmentInfoVO {

    /**
     * 部门id
     */
    private String id;
    /**
     * 部门名
     */
    private String departmentName;
    /**
     * 上级部门id
     */
    private String parentId;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 分类:1.集团/2.分公司/3.部门
     */
    private String category;
    /**
     * 负责人
     */
    private String principal;
    /**
     * 电话
     */
    private String phone;
    /**
     * 备注
     */
    private String remark;
    /**
     * 排序
     */
    private int orderNum;
    /**
     * 上级部门名称
     */
    private String parentName;
    /**
     * 所有上级名称列表
     */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<String> parentNameList;

}
