package com.esv.superhive.cc.module.cache.controller;

import com.esv.superhive.cc.module.cache.service.CacheTestService;
import com.esv.superhive.cc.module.user.entity.UserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping("cache")
@CacheConfig(cacheNames = {"user"})
public class CacheTestController {

    private CacheTestService cacheTestService;

    @Autowired
    public CacheTestController(CacheTestService cacheTestService) {
        this.cacheTestService = cacheTestService;
    }

    /**
     * 查询出一条数据并且添加到缓存
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/getUser", method = RequestMethod.GET)
    @Cacheable
    public UserEntity getPrud(@RequestParam(required = true) String userId) {
        log.info("如果没有缓存，就会调用下面方法，如果有缓存，则直接输出，不会输出此段话");
        return cacheTestService.getUser(Integer.parseInt(userId));
    }

    @PostMapping("getUser1")
    @Cacheable(key = "#userEntity.id")
    public UserEntity getPrud1(@RequestBody UserEntity userEntity) {
        log.info("如果没有缓存，就会调用下面方法，如果有缓存，则直接输出，不会输出此段话");
        return cacheTestService.getUser(userEntity.getId().intValue());
    }

    /**
     * 删除一个缓存
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/deleteUser", method = RequestMethod.GET)
//    @CacheEvict("userCache")
    @CacheEvict
    public String deleteUser(@RequestParam(required = true) String userId) {
        return "删除成功";
    }

    @PostMapping("deleteUser1")
    @CacheEvict
    public String deleteUser1(@RequestBody UserEntity userEntity) {
        return "删除成功";
    }

    /**
     * 添加一条保存的数据到缓存，缓存的key是当前user的id
     *
     * @param user
     * @return
     */
    @RequestMapping(value = "/saveUser", method = RequestMethod.POST)
//    @CachePut(value = "userCache", key = "#result.userId +''")
    @CachePut(key = "#result.userId +''")
    public UserEntity saveUser(UserEntity user) {
        return user;
    }

    /**
     * 返回结果userPassword中含有nocache字符串就不缓存
     *
     * @param userId
     * @return
     */
    @RequestMapping(value = "/getUser2", method = RequestMethod.GET)
    @CachePut(value = "userCache", unless = "#result.userPassword.contains('nocache')")
    public UserEntity getUser2(@RequestParam(required = true) String userId) {
        log.info("如果走到这里说明，说明缓存没有生效！");
        UserEntity user = new UserEntity();
        user.setId(Long.valueOf(userId));
        user.setAccount("name_nocache"+userId);
        user.setPassword("password_" + userId);
        return user;
    }

    @RequestMapping(value = "/getUser3", method = RequestMethod.GET)
    @Cacheable(value = "userCache", key = "#root.targetClass.getName() + #root.methodName + #userId")
    public UserEntity getUser3(@RequestParam(required = true) String userId) {
        log.info("如果第二次没有走到这里说明缓存被添加了");
        return cacheTestService.getUser(Integer.parseInt(userId));
    }

}
