package com.esv.superhive.cc.module.account.dto;

import com.esv.superhive.cc.module.system.entity.SystemEntity;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class UserSystemDTO {

    /**
     * 系统id
     */
    private Long id;
    /**
     * 系统标识编码
     */
    private String systemCode;
    /**
     * 系统名称
     */
    private String systemName;
    /**
     * 系统图标
     */
    private String icon;
    /**
     * 系统url
     */
    private String url;
    /**
     * 开发url
     */
    private String devUrl;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;

    /**
     * 系统权限列表
     */
    private List<UserSystemRoleDTO> userSystemRoleList;

    public UserSystemDTO() {

    }

    public UserSystemDTO(SystemEntity systemEntity) {
        this.id = systemEntity.getId();
        this.systemCode = systemEntity.getSystemCode();
        this.systemName = systemEntity.getSystemName();
        this.icon = systemEntity.getIcon();
        this.url = systemEntity.getUrl();
        this.devUrl = systemEntity.getDevUrl();
        this.status = systemEntity.getStatus();
        userSystemRoleList = new ArrayList<>();
    }

}
