package com.esv.superhive.cc.module.account.controller;

import com.esv.superhive.cc.common.component.LoginMBean;
import com.esv.common.response.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("jmx")
public class JmxController {

    private LoginMBean loginMBean;

    @Autowired
    public JmxController(LoginMBean loginMBean) {
        this.loginMBean = loginMBean;
    }

    @RequestMapping(value = "loginCount", method = RequestMethod.GET)
    public R loginCount(@RequestParam(value = "count", required = false) Integer count) {
        if (count != null) {
            loginMBean.setCount(count);
        }
        return R.ok().put("count", loginMBean.getCount());
    }

}
