package com.esv.superhive.cc.common.component;

import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(
        objectName = "com.esvtek.smartdata.authority:type=LoginMBean",
        description = "登录次数统计"
)
public class LoginMBean {

    private int count;

    /**
     * 暴露属性
     */
    @ManagedAttribute(description = "这是登录次数")
    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}
