package com.esv.superhive.cc.util;

import com.alibaba.fastjson.JSONObject;
import com.esv.superhive.cc.common.exception.RRException;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

public class ParamsUtils {

    public static String genTransparentParam(JSONObject reqBody) {
        String params = "";
        StringBuffer paramSb = new StringBuffer();
        String key;
        for (Map.Entry<String, Object> entry : reqBody.entrySet()) {
            key = entry.getKey();
            paramSb.append("&").append(key).append("=").append(entry.getValue().toString());
        }
        params = paramSb.toString();
        params = params.replaceFirst("&", "");

        return params;
    }

    public static void checkParamNecessary(JSONObject appRequestBody, String[] params) throws RRException {
        for (String param : params) {
            if (appRequestBody.containsKey(param)) {
                String value = appRequestBody.getString(param);
                if (StringUtils.isEmpty(value)) {
                    throw new RRException("参数["+param+"]是必填的");
                }
            } else {
                throw new RRException("参数["+param+"]是必填的");
            }
        }
    }

    public static void checkParamLength(JSONObject appRequestBody, String[] params) throws RRException {
        String key;
        int length;
        for (String param : params) {
            if (param.contains("<=")) {
                key = param.split("<=")[0];
                length = Integer.parseInt(param.split("<=")[1]);
                if (appRequestBody.containsKey(key) && appRequestBody.getString(key).length() > length) {
                    throw new RRException("参数["+key+"]的值长度不合法");
                }
            } else if (param.contains("==")) {
                key = param.split("==")[0];
                length = Integer.parseInt(param.split("==")[1]);
                if (appRequestBody.containsKey(key) && appRequestBody.getString(key).length() != length) {
                    throw new RRException("参数["+key+"]的值长度不合法");
                }
            } else if (param.contains(">=")) {
                key = param.split(">=")[0];
                length = Integer.parseInt(param.split(">=")[1]);
                if (appRequestBody.containsKey(key) && appRequestBody.getString(key).length() < length) {
                    throw new RRException("参数["+key+"]的值长度不合法");
                }
            } else {

            }
        }
    }

}
