package com.esv.superhive.cc.module.user.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.cc.common.exception.RRException;
import com.esv.superhive.cc.module.role.entity.RoleEntity;
import com.esv.superhive.cc.module.role.service.RoleService;
import com.esv.superhive.cc.module.user.dao.UserRoleDao;
import com.esv.superhive.cc.module.user.entity.UserRoleEntity;
import com.esv.superhive.cc.module.user.service.UserRoleService;
import com.esv.superhive.cc.util.ListCompareUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@RefreshScope
@Service("userRoleService")
public class UserRoleServiceImpl extends ServiceImpl<UserRoleDao, UserRoleEntity> implements UserRoleService {

    private RoleService roleService;

    @Autowired
    public UserRoleServiceImpl(RoleService roleService) {
        this.roleService = roleService;
    }

    /**
     * description 编辑用户角色
     * param [userEntity, editUser]
     * return void
     * author chenfm
     * createTime 2020/3/17 16:29
     **/
    public void editUserRole(Long userId, String roleIdStr) {
        // 查询角色信息
        List<Long> roleIdList = new ArrayList<>();
        if (StringUtils.isNotBlank(roleIdStr)) {
            for (String roleId : roleIdStr.split(",")) {
                roleIdList.add(Long.parseLong(roleId));
            }
            List<RoleEntity> roleEntityList =  roleService.listByIds(roleIdList);
            if (roleEntityList.size() != roleIdList.size()) {
                throw new RRException("无效的角色数据", 1003);
            }
        }
        // 保存用户角色
        this.saveUserRole(userId, roleIdList);
    }

    @Override
    public void saveUserRole(Long userId, List<Long> roleIdList) {
        List<UserRoleEntity> oldList = listByUserId(userId);
        List<Long> oldRoleIdList = new ArrayList<>(oldList.size());
        oldList.forEach(oldRoleEntity -> {
            oldRoleIdList.add(oldRoleEntity.getRoleId());
        });

//        Collections.sort(oldRoleIdList);
//        Collections.sort(roleIdList);
//        String oldStr = Arrays.toString(oldRoleIdList.toArray());
//        String newStr = Arrays.toString(roleIdList.toArray());
        // 新旧角色相同, 不做处理
        if (ListCompareUtil.longListSame(oldRoleIdList, roleIdList)) {
            return;
        }

        // 新旧角色不同, 删除所有旧角色重新插入
        this.deleteByUserId(userId);
        List<UserRoleEntity> list = new ArrayList<>();
        // 新增帐号角色
        roleIdList.forEach(roleId -> {
            UserRoleEntity entity = new UserRoleEntity();
            entity.setUserId(userId);
            entity.setRoleId(roleId);
            list.add(entity);
        });
        this.saveBatch(list);
    }

    @Override
    public List<UserRoleEntity> listByUserId(long userId) {
        UserRoleEntity entity = new UserRoleEntity();
        entity.setUserId(userId);
        return baseMapper.selectList(new QueryWrapper<>(entity));
    }

    @Override
    public void deleteByUserId(long userId) {
        UserRoleEntity entity = new UserRoleEntity();
        entity.setUserId(userId);
        baseMapper.delete(new QueryWrapper<>(entity));
    }

    @Override
    public int countByRoleId(long roleId) {
        UserRoleEntity userRoleEntity = new UserRoleEntity();
        userRoleEntity.setUserId(roleId);
        int userRoleCount = count(new QueryWrapper<>(userRoleEntity));
        return userRoleCount;
    }

    @Override
    public boolean hasSuperAdminRole(long userId) {
        return hasRole(userId, roleService.getSuperAdminRoleId());
    }

    /**
     * description 查询用户所有角色内是否包含roleId
     * param [userId, roleId]
     * return boolean
     * author chenfm
     * createTime 2020/3/17 16:13
     **/
    private boolean hasRole(long userId, Long roleId) {
        List<UserRoleEntity> userRoleList = listByUserId(userId);
        for (UserRoleEntity entity : userRoleList) {
            if (entity.getRoleId().equals(roleId)) {
                return true;
            }
        }
        return false;
    }

}
