package com.esv.superhive.cc.module.tenant.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.cc.module.department.vo.DepartmentInfoVO;
import com.esv.superhive.cc.module.department.vo.DepartmentVO;
import com.esv.superhive.cc.module.tenant.dto.TenantAdminRoleDTO;
import com.esv.superhive.cc.module.tenant.entity.TenantEntity;
import com.esv.superhive.cc.module.tenant.form.TenantForm;

import java.util.List;

/**
 * 公司表
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-03-09 11:12:29
 */
public interface TenantService extends IService<TenantEntity> {

    /**
     * description 查询租户部门树列表
     * param [tenantId, departmentName]
     * return java.util.List<DepartmentVO>
     * author chenfm
     * createTime 2020/3/17 13:42
     **/
    List<DepartmentVO> TenantDepartmentVOTreeList(Integer dataPerm, Long tenantId, String departmentName);

    /**
     * description 根据角色类型查询租户角色信息
     * param [roleType]
     * return java.util.List<com.esv.cc.module.tenant.dto.TenantAdminRoleDTO>
     * author chenfm
     * createTime 2020/4/9 17:07
     **/
    List<TenantAdminRoleDTO> tenantAdminRoleList(Integer roleType);

    /**
     * description 租户信息
     * param [tenantId]
     * return DepartmentInfoVO
     * author chenfm
     * createTime 2020/3/17 13:49
     **/
    DepartmentInfoVO tenantInfo(Long tenantId);
    /**
     * @description 根据租户编码查询租户信息
     * param [tenantCode]
     * @return TenantEntity
     * @author chenfm
     * @createTime 2020/3/11 11:20
     **/
    TenantEntity findByCode(String tenantCode);

    /**
     * @description 查询租户是否可删除
     * param [tenantId]
     * @return boolean
     * @author chenfm
     * @createTime 2020/3/11 11:21
     **/
    boolean canDelete(Long tenantId);

    /**
     * description 是否是租户管理员角色
     * param [role]
     * return java.lang.Boolean
     * author chenfm
     * createTime 2020/4/2 20:30
     **/
    Boolean isTenantAdminRole(Long role);

    /**
     * description 新增租户
     * param [tenantForm]
     * return void
     * author HuangChaobin
     * createTime 2020/06/22 17:11
     **/
    void addTenant(TenantForm tenantForm);

    /**
     * description 删除租户
     * param [id]
     * return void
     * author HuangChaobin
     * createTime 2020/06/22 17:51
     **/
    void deleteTenant(Long id);

}

