package com.esv.superhive.cc.module.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.cc.common.cache.CacheNames;
import com.esv.superhive.cc.module.account.dto.UserSystemDTO;
import com.esv.superhive.cc.module.account.dto.UserSystemRoleDTO;
import com.esv.superhive.cc.module.role.entity.RoleEntity;
import com.esv.superhive.cc.module.role.service.RoleService;
import com.esv.superhive.cc.module.system.dao.SystemDao;
import com.esv.superhive.cc.module.system.dto.SystemDTO;
import com.esv.superhive.cc.module.system.entity.SystemEntity;
import com.esv.superhive.cc.module.system.service.SystemService;
import com.esv.superhive.cc.module.user.service.UserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CacheConfig(cacheNames = CacheNames.SYSTEM_BY_CODE)
@Service("systemService")
public class SystemServiceImpl extends ServiceImpl<SystemDao, SystemEntity> implements SystemService {

    private RoleService roleService;

    private UserRoleService userRoleService;

    @Autowired
    public SystemServiceImpl(RoleService roleService, UserRoleService userRoleService) {
        this.roleService = roleService;
        this.userRoleService = userRoleService;
    }

    @Override
    public IPage<SystemDTO> page(IPage page, String systemName, Integer status) {
        Map<String, Object> param = new HashMap<>();
        param.put("systemName", systemName);
        param.put("status", status);
        return baseMapper.page(page, param);
    }

    @Cacheable
    @Override
    public SystemEntity getByCode(String code) {
        QueryWrapper<SystemEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("system_code", code);
        return this.getOne(wrapper);
    }

    @Override
    public List<UserSystemDTO> userSystemList(Long tenantId, Long userId) {
        if (userRoleService.hasSuperAdminRole(userId)) {
            // 用户角色包括超级管理员
            List<UserSystemDTO> list = new ArrayList<>();
            List<SystemEntity> systemEntityList = list();
            RoleEntity roleEntity = roleService.getById(roleService.getSuperAdminRoleId());
            systemEntityList.forEach(systemEntity -> {
                UserSystemDTO userSystemDTO = new UserSystemDTO(systemEntity);
                UserSystemRoleDTO userSystemRoleDTO = new UserSystemRoleDTO(roleEntity.getId(), roleEntity.getRoleName());
                userSystemDTO.getUserSystemRoleList().add(userSystemRoleDTO);
                list.add(userSystemDTO);
            });
            return list;
        } else {
            // 普通用户
            return baseMapper.userSystemList(userId);
        }
    }
}
