package com.esv.superhive.cc.module.system.form;

import com.esv.superhive.cc.common.form.Update;
import com.esv.superhive.cc.common.form.Add;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: esv-cc
 * @name: SystemForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/17 15:49
 * @version:1.0
 */
@Data
public class SystemForm {

    /**
     * 系统id
     */
    @NotNull(groups = {Update.class}, message = "系统id不能为空")
    private Long id;
    /**
     * 系统标识编码
     */
    @NotNull(groups = {Add.class, Update.class}, message = "系统标识不能为空")
    @Length(groups = {Add.class, Update.class}, max = 50, message = "系统标识长度不合法")
    private String systemCode;
    /**
     * 系统名称
     */
    @NotNull(groups = {Add.class, Update.class}, message = "系统名称不能为空")
    @Length(groups = {Add.class, Update.class}, max = 100, message = "系统名称长度不合法")
    private String systemName;

    /**
     * 系统图标
     */
    @Length(groups = {Add.class, Update.class}, max = 100, message = "系统图标长度不合法")
    private String icon;

    /**
     * 系统url
     */
    @NotNull(groups = {Add.class, Update.class}, message = "系统根目录不能为空")
    @Length(groups = {Add.class, Update.class}, max = 255, message = "系统url长度不合法")
    private String url;
    /**
     * 开发url
     */
    @NotNull(groups = {Add.class, Update.class}, message = "开发根目录不能为空")
    @Length(groups = {Add.class, Update.class}, max = 255, message = "开发url长度不合法")
    private String devUrl;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;

}
