package com.esv.superhive.cc.module.menu.form;

import com.esv.superhive.cc.common.form.Update;
import com.esv.superhive.cc.common.form.Add;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

@Data
public class MenuForm {
    /**
     * 菜单id
     */
    @NotNull(groups = {Update.class}, message = "菜单id不能为空")
    private Long id;
    /**
     * 父菜单ID，一级菜单为0
     */
    @NotNull(groups = {Add.class, Update.class}, message = "上级菜单id不能为空")
    private String parentRowKey;
    /**
     * 菜单编码
     */
    @NotNull(groups = {Add.class, Update.class}, message = "菜单编码不能为空")
    @Length(groups = {Add.class, Update.class}, max = 50, message = "菜单编码长度不合法")
    private String menuCode;
    /**
     * 菜单名称
     */
    @NotNull(groups = {Add.class, Update.class}, message = "菜单名称不能为空")
    @Length(groups = {Add.class, Update.class}, max = 50, message = "菜单名称长度不合法")
    private String name;
    /**
     * 菜单URL
     */
    @Length(groups = {Add.class, Update.class}, max = 200, message = "菜单URL长度不合法")
    private String url;
    /**
     * 授权(多个用逗号分隔，如：user:list,user:create)
     */
    @Length(groups = {Add.class, Update.class}, max = 500, message = "授权长度不合法")
    private String perms;
    /**
     * 类型   1：目录   2：菜单   3：按钮
     */
    @NotNull(groups = {Add.class, Update.class}, message = "菜单类型不能为空")
    private Integer type;
    /**
     * 菜单图标
     */
    @Length(groups = {Add.class, Update.class}, max = 50, message = "菜单图标长度不合法")
    private String icon;
    /**
     * 排序
     */
    private Integer orderNum;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;
    /**
     * 系统id
     */
    private Long systemId;
}
