package com.esv.superhive.cc.module.index.controller;

import com.esv.superhive.cc.module.index.service.IndexService;
import com.esv.superhive.cc.module.index.vo.IndexSystemVO;
import com.esv.superhive.cc.module.menu.dto.MenuDTO;
import com.esv.superhive.cc.module.system.entity.SystemEntity;
import com.esv.superhive.cc.module.system.service.SystemService;
import com.esv.common.response.R;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Slf4j
@RestController
@RequestMapping("index")
public class IndexController {

    private IndexService indexService;

    private SystemService systemService;

    @Autowired
    public IndexController(IndexService indexService, SystemService systemService) {
        this.indexService = indexService;
        this.systemService = systemService;
    }

    /**
     * description 查询所有系统菜单
     * param [userId]
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/13 17:27
     **/
    @Transactional
    @GetMapping("userMenuTree")
    public R userMenuTree(@RequestHeader(GatewayHeaders.USER_ID) Long userId) {
        List<SystemEntity> systemList = systemService.list();
        List<IndexSystemVO> systemVOList = new ArrayList<>(systemList.size());
        for (SystemEntity entity : systemList) {
            IndexSystemVO indexSystemVO = new IndexSystemVO();
            BeanUtils.copyProperties(entity, indexSystemVO);
            List<MenuDTO> menuDTOList = indexService.userSystemMenuTree(userId, entity.getId());
            indexSystemVO.setMenuList(menuDTOList);
            systemVOList.add(indexSystemVO);
        }
        return R.ok(systemVOList);
    }

    /**
     * description 查询所有系统按钮权限
     * param [userId]
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/13 17:27
     **/
    @Transactional
    @GetMapping("userMenuCodeList")
    public R userMenuCodeList(@RequestHeader(GatewayHeaders.USER_ID) Long userId) {
        Set<String> menuCodeSet = new HashSet<>();
        List<SystemEntity> systemList = systemService.list();
        for (SystemEntity entity : systemList) {
            List<String> menuCodeList = indexService.menuCodeList(userId, entity.getId());
            for (String menuCode : menuCodeList) {
                if (StringUtils.isNotBlank(menuCode)) {
                    menuCodeSet.add(menuCode);
                }
            }
        }
        return R.ok(menuCodeSet);
    }
/*
    @Transactional
    @RequestMapping("userPermsList")
    public R userPermsList(@RequestHeader(HttpHeaderKeys.USER_ID) Long userId,
                           @RequestHeader(HttpHeaderKeys.SYSTEM_CODE) String systemCode) {
        SystemEntity entity = systemService.selectByUri(systemCode);
        if (entity == null) {
            return R.error("应用不存在");
        }
        List<String> permsList = menuService.listUserPerms(entity.getId(),
                userId == Long.parseLong(superAdminUserId) ? null : userId);
        Set<String> permsSet = new HashSet<>();
        for (String perms : permsList) {
            if (StringUtils.isNotBlank(perms)) {
                permsSet.add(perms);
            }
        }
        return R.ok(permsSet);
    }
*/
}
