package com.esv.superhive.cc.module.department.vo;

import com.esv.superhive.cc.module.department.entity.DepartmentEntity;
import com.esv.superhive.cc.module.tenant.entity.TenantEntity;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.List;

/**
 * @description:
 * @project: esv-cc
 * @name: DepartmentVO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/11 13:31
 * @version:1.0
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DepartmentVO {
    /**
     * 部门id
     */
    private String id;
    /**
     * 部门名
     */
    private String departmentName;
    /**
     * 上级部门id
     */
    private String parentId;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 分类:1.集团/2.分公司/3.部门
     */
    private String category;
    /**
     * 负责人
     */
    private String principal;
    /**
     * 电话
     */
    private String phone;
    /**
     * 备注
     */
    private String remark;
    /**
     * 排序
     */
    private int orderNum;
    /**
     * @description 用户数
     * @author chenfm
     * @createTime 2020/3/11 13:32
     **/
    private Integer userCount;
    /**
     * @description 子部门
     * @author chenfm
     * @createTime 2020/3/11 13:32
     **/
    private List<DepartmentVO> children;

    public DepartmentVO() {

    }

    public DepartmentVO(TenantEntity tenantEntity) {
        this.id = "t_" + tenantEntity.getId();
        this.departmentName = tenantEntity.getTenantName();
        this.parentId = "0";
        this.tenantId = tenantEntity.getId();
        this.category = "0";
        this.principal = tenantEntity.getContact();
        this.phone = tenantEntity.getContactPhone();
        this.userCount = 0;
    }

    public DepartmentVO(DepartmentEntity departmentEntity) {
        this.id = String.valueOf(departmentEntity.getId());
        this.departmentName = departmentEntity.getDepartmentName();
        this.parentId = String.valueOf(departmentEntity.getParentId());
        this.tenantId = departmentEntity.getTenantId();
        this.category = "2";
        this.principal = departmentEntity.getPrincipal();
        this.phone = departmentEntity.getPhone();
    }

}
