package com.esv.superhive.cc.module.account.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;

/**
 * 帐号登录信息表
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-20 09:52:11
 */
@Data
@TableName("cc_user_login_info")
public class UserLoginInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	@TableId
	private Long id;
	/**
	 * 用户ID
	 */
	private Long userId;
	/**
	 * 登录IP
	 */
	private String ip;
	/**
	 * Token
	 */
	private String token;
	/**
	 * 状态：0-已登录、1-已登出
	 */
	private String status;
	/**
	 * 登录时间
	 */
	private Date loginTime;
	/**
	 * description 上次登录ip
	 * author chenfm
	 * createTime 2020/3/16 16:20
	 **/
	private String lastIp;
	/**
	 * description 上次登录时间
	 * author chenfm
	 * createTime 2020/3/16 16:20
	 **/
	private Date lastLoginTime;
	/**
	 * 登出时间
	 */
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private Date logoutTime;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}
}
