package com.esv.superhive.cc.config;

import com.esv.superhive.cc.common.filter.LogbackFilter;
import com.esv.superhive.cc.common.filter.RestLogFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description： 注册请求Filter
 * @author：hcbmailbox@163.com
 * @date：2020/1/8
 */
@Configuration
public class FilterConfig {

    private static final String URL = "/*";

    @Bean
    public LogbackFilter getLogbackFilter() {
        return new LogbackFilter();
    }

    @Bean
    public RestLogFilter getRestLogFilter() {
        return new RestLogFilter();
    }

    @Bean
    public FilterRegistrationBean<LogbackFilter> logbackFilterRegister() {
        FilterRegistrationBean<LogbackFilter> registration = new FilterRegistrationBean<>();
        registration.setFilter(getLogbackFilter());
        registration.addUrlPatterns(URL);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RestLogFilter> restLogFilterRegister() {
        FilterRegistrationBean<RestLogFilter> filterRegistrationBean=new FilterRegistrationBean<>();
        filterRegistrationBean.setFilter(getRestLogFilter());
        filterRegistrationBean.addUrlPatterns(URL);
        filterRegistrationBean.setOrder(2);
        return filterRegistrationBean;
    }

}
