package com.esv.superhive.cc.common.filter;

import com.esv.superhive.cc.common.constants.CommonConstants;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.UUID;

/**
 * @description： 设置Logback线程唯一ID
 * @author：hcbmailbox@163.com
 * @date：2020/1/8
 */
@Slf4j
public class LogbackFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void destroy() {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        // 获取来自上游服务的传参traceId
        HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        String traceId = httpServletRequest.getHeader("gateway_traceid");
        if (StringUtils.isBlank(traceId)) {
            traceId = httpServletRequest.getHeader("trace_id");
        }
        boolean bInsertMDC = setMDC(traceId);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        } finally {
            if(bInsertMDC) {
                MDC.remove("traceId");
            }
        }
    }

    private boolean setMDC(String traceId) {
        if (StringUtils.isEmpty(traceId) || CommonConstants.NULL_STRING.equalsIgnoreCase(traceId)) {
            traceId = UUID.randomUUID().toString().replace("-", "");
        }
        MDC.put("traceId", traceId);
        return true;
    }
}
