package com.esv.datacenter.cc.module.account.dto;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @description： 用户登录信息
 * @author：hcbmailbox@163.com
 * @date：2020/1/20
 */
@Data
public class UserLoginInfoDTO {

    private Long userId;

    private String account;

    private String realName;

    private String email;

    private String mobile;

    private String departmentName;

    private String roleName;

    /**
     * 状态：0-已登录、1-已登出
     */
    private String status;

    private String loginIp;

    private Long loginTime;

    private Long logoutTime;

    private String lastLoginIp;

    private Long lastLoginTime;

    /**
     * 用户可访问系统
     */
    private List<UserSystemDTO> userSystemList;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
