package com.esv.datacenter.cc.config.mybatis;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.esv.datacenter.cc.util.ReqUtils;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @description:
 * @project: esv-cc
 * @name: com.esv.cc.config.mybatis.MetaHandler
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/7 20:15
 * @version:1.0
 */
@Slf4j
@Component
public class EsvMetaObjectHandler implements MetaObjectHandler {

    @Override
    public void insertFill(MetaObject metaObject) {
        if (metaObject.hasSetter("createUser")) {
            String userAccount = ReqUtils.getRequestHeader(GatewayHeaders.USER_ACCOUNT);
            this.setFieldValByName("createUser", userAccount, metaObject);
        }
        if (metaObject.hasSetter("createTime")) {
            this.setFieldValByName("createTime", new Date(), metaObject);
        }
        if (metaObject.hasSetter("tenantId") && metaObject.getValue("tenantId") == null) {
            String tenantId = ReqUtils.getRequestHeader(GatewayHeaders.TENANT_ID);
            this.setFieldValByName("tenantId", Long.parseLong(tenantId), metaObject);
        }
        if (metaObject.hasSetter("departmentId") && metaObject.getValue("departmentId") == null) {
            String departmentId = ReqUtils.getRequestHeader(GatewayHeaders.DEPARTMENT_ID);
            this.setFieldValByName("departmentId", Long.parseLong(departmentId), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        if (metaObject.hasSetter("updateUser")) {
            String userAccount = ReqUtils.getRequestHeader(GatewayHeaders.USER_ACCOUNT);
            this.setFieldValByName("updateUser", userAccount, metaObject);
        }
        if (metaObject.hasSetter("updateTime")) {
            this.setFieldValByName("updateTime", new Date(), metaObject);
        }
    }
}
