package com.esv.datacenter.cc.module.user.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.cc.module.user.dto.UserDTO;
import com.esv.datacenter.cc.module.user.entity.UserEntity;

import java.util.Map;

/**
 * 系统用户
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
public interface UserService extends IService<UserEntity> {

    /**
     * 新增用户
     * @param userEntity
     * @return
     */
    UserEntity insert(UserEntity userEntity);

    /**
     * 更新用户信息
     * @param userEntity
     * @return
     */
    UserEntity updateUserInfoById(UserEntity userEntity);

    /**
     * 查询用户列表（含角色id）
     * @param page
     * @param queryObj
     * @return
     */
    void getUserList(IPage<UserDTO> page, Map<String, Object> queryObj);

    /**
     * 通过帐号查询用户
     * @param account
     * @return
     */
    UserEntity getUserByAccount(String account);

    /**
     * 查询用户详情
     * @param queryObj
     * @return
     */
    UserDTO getUserDetailInfo(Map<String, Object> queryObj);

    /**
     * description 删除用户
     * param [userId]
     * return boolean
     * author chenfm
     * createTime 2020/3/13 13:47
     **/
    boolean delete(long userId);

}

