package com.esv.datacenter.cc.module.tenant.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantAdminDTO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/12 17:34
 * @version:1.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class TenantAdminDTO {

    /**
     * 用户id
     */
    private Long id;
    /**
     * 用户名
     */
    private String account;
    /**
     * 姓名
     */
    private String realName;
    /**
     * 密码
     */
    @JsonIgnore
    private String password;
    /**
     * 盐
     */
    @JsonIgnore
    private String salt;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 状态  0：禁用   1：正常
     */
    private Integer status;
    /**
     * 租户id
     */
    private Long tenantId;
    /**
     * 所属部门id
     */
    @JsonIgnore
    private Long departmentId;
    /**
     * 职位
     */
    private String position;
    /**
     * description 租户名
     * author chenfm
     * createTime 2020/3/12 17:35
     **/
    private String tenantName;

    /**
     * description 角色id
     * author chenfm
     * createTime 2020/4/2 20:08
     **/
    private Long roleId;

    /**
     * description 用户类型 0-平台管理员, 1-租户管理员, 2-普通用户
     * author chenfm
     * createTime 2020/4/9 19:50
     **/
    private Integer type;

    /**
     * description 是否可编辑
     * author chenfm
     * createTime 2020/4/2 20:08
     **/
    private Boolean canEdited;

    public Boolean getCanEdited() {
        return id != 1;
    }
}
