package com.esv.datacenter.cc.module.role.form;

import com.esv.datacenter.cc.module.role.entity.RoleMenuEntity;
import com.esv.datacenter.cc.module.role.vo.RowKeyVO;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @project: esv-cc
 * @name: com.esv.cc.module.role.form.RowKeyForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/9 9:18
 * @version:1.0
 */
@Data
public class RowKeyForm {

    /**
     * description 菜单权限列表
     * author chenfm
     * createTime 2020/4/9 9:21
     **/
    private List<RowKeyVO> rowKeyList;

    /**
     * description 根据传入的菜单权限列表获取使用权限及数据权限
     * param []
     * return java.util.List<com.esv.cc.module.role.entity.RoleMenuEntity>
     * author chenfm
     * createTime 2020/4/9 9:21
     **/
    public List<RoleMenuEntity> roleMenuEntityList() {
        if (this.rowKeyList == null) {
            return new ArrayList<>();
        }
        List<RoleMenuEntity> menuList = new ArrayList<>(this.rowKeyList.size());
        for (RowKeyVO rowKeyVO : this.rowKeyList) {
            if (!"-1".equalsIgnoreCase(rowKeyVO.getRowKey().split("_")[1])) {
                RoleMenuEntity roleMenuEntity = new RoleMenuEntity();
                roleMenuEntity.setMenuId(Long.valueOf(rowKeyVO.getRowKey().split("_")[0]));
                roleMenuEntity.setDataPerm(rowKeyVO.getDataPerm());
                menuList.add(roleMenuEntity);
            }
        }
        return menuList;
    }
}
