package com.esv.datacenter.cc.module.role.form;

import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: esv-cc
 * @name: RoleCategoryForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/17 15:36
 * @version:1.0
 */
@Data
public class RoleCategoryForm {
    /**
     * 主键
     */
    @NotNull(groups = {Update.class}, message = "类别名称不能为空")
    private Long id;
    /**
     * 类别名称
     */
    @NotNull(groups = {Add.class, Update.class}, message = "类别名称不能为空")
    private String categoryName;
    /**
     * 排序
     */
    @NotNull(groups = {Add.class, Update.class}, message = "排序不能为空")
    private Integer orderNum;
}
