package com.esv.datacenter.cc.module.role.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.datacenter.cc.module.role.dto.RoleDTO;
import com.esv.datacenter.cc.module.role.dto.TenantRoleDTO;
import com.esv.datacenter.cc.module.role.entity.RoleEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 角色
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-10 15:25:41
 */
@Mapper
public interface RoleDao extends BaseMapper<RoleEntity> {

    /**
     * description 分页查询角色列表
     * param [page, param]
     * return com.baomidou.mybatisplus.core.metadata.IPage<RoleDTO>
     * author chenfm
     * createTime 2020/3/16 10:04
     **/
    IPage<RoleDTO> listRoleDTOPage(IPage<RoleDTO> page, RoleDTO param);

    /**
     * description 根据租户分组查询所有角色
     * param []
     * return java.util.List<com.esv.cc.module.role.dto.TenantRoleDTO>
     * author chenfm
     * createTime 2020/4/9 9:23
     **/
    List<TenantRoleDTO> allByTenant(Long tenantId, Integer type);
}
