package com.esv.datacenter.cc.module.account.form;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;

/**
 * @description：
 * @author：hcbmailbox@163.com
 * @date：2020/1/13
 */
@Data
public class AccountForm {

    @NotEmpty(message="验证码id不能为空")
    private String id;

    @NotEmpty(message="验证码不能为空")
    private String captcha;

    /**
     * 用户名
     */
    @Length(max = 50, message = "账号长度不合法")
    @NotEmpty(message="账号不能为空")
    private String account;

    /**
     * 密码
     */
    @Length(min = 32, max = 32, message = "密码长度不合法")
    @NotEmpty(message = "密码不能为空")
    private String password;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }

}
