package com.esv.datacenter.cc.module.apiauth.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import com.esv.datacenter.cc.module.apiauth.entity.ApiAuthorityEntity;
import com.esv.datacenter.cc.module.apiauth.form.ApiAuthorityDeleteForm;
import com.esv.datacenter.cc.module.apiauth.form.ApiAuthorityForm;
import com.esv.datacenter.cc.module.apiauth.service.ApiAuthorityService;
import com.esv.common.response.R;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description： API鉴权数据维护Controller
 * @author：hcbmailbox@163.com
 * @date：2020/1/10
 */
@RestController
@RequestMapping("apiauth")
@Slf4j
public class ApiAuthController {

    private ApiAuthorityService apiAuthorityService;

    @Autowired
    public ApiAuthController(ApiAuthorityService apiAuthorityService) {
        this.apiAuthorityService = apiAuthorityService;
    }

    @GetMapping("/list")
    public R list(
            @RequestParam(value = "current", defaultValue = "1") Integer current,
            @RequestParam(value = "size", defaultValue = "10") Integer size,
            @RequestParam(value = "api", required = false) String api,
            @RequestParam(value = "authType", required = false) String authType) {
        IPage<ApiAuthorityEntity> page = new Page<>(current, size);
        QueryWrapper<ApiAuthorityEntity> wrapper = new QueryWrapper<>();
        if (StringUtils.isNotBlank(api)) {
            wrapper.like("api", api);
        }
        if (StringUtils.isNotBlank(authType)) {
            wrapper.eq("auth_type", authType);
        }
        page = apiAuthorityService.page(page, wrapper);
        return R.ok(page);
    }

    @PostMapping("add")
    public R add(@RequestBody @Validated(Add.class) ApiAuthorityForm apiAuthorityForm) {
        ApiAuthorityEntity apiAuthorityEntity = new ApiAuthorityEntity();
        BeanUtils.copyProperties(apiAuthorityForm, apiAuthorityEntity);
        apiAuthorityService.save(apiAuthorityEntity);
        apiAuthorityService.refreshApiMap();
        return R.ok();
    }

    @PostMapping("update")
    public R update(@RequestBody @Validated(Update.class) ApiAuthorityForm apiAuthorityForm) {
        ApiAuthorityEntity apiAuthorityEntity = new ApiAuthorityEntity();
        BeanUtils.copyProperties(apiAuthorityForm, apiAuthorityEntity);
        apiAuthorityService.updateById(apiAuthorityEntity);
        apiAuthorityService.refreshApiMap();
        return R.ok();
    }

    @PostMapping("delete")
    public R delete(@RequestBody @Validated ApiAuthorityDeleteForm apiAuthorityDeleteForm) {
        List<Long> idList = apiAuthorityDeleteForm.getIdList();
        apiAuthorityService.removeByIds(idList);
        apiAuthorityService.refreshApiMap();
        return R.ok();
    }

    /**
     * 刷新Api Map
     * @return
     * @throws Exception
     */
    @GetMapping("refresh")
    public R refresh() {
        apiAuthorityService.refreshApiMap();
        return R.ok();
    }
}
