package com.esv.datacenter.cc.module.user.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;

/**
 * 系统用户
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Data
@TableName("cc_user")
public class UserEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 用户id
	 */
	@TableId
	private Long id;
	/**
	 * 用户名
	 */
	private String account;
	/**
	 * 姓名
	 */
	private String realName;
	/**
	 * 密码
	 */
	private String password;
	/**
	 * 盐
	 */
	private String salt;
	/**
	 * 邮箱
	 */
	private String email;
	/**
	 * 手机号
	 */
	private String mobile;
	/**
	 * 状态  0：禁用   1：正常
	 */
	private Integer status;
	/**
	 * 租户id
	 */
	private Long tenantId;
	/**
	 * 所属部门id
	 */
	private Long departmentId;
	/**
	 * 职位
	 */
	private String position;
	/**
	 * description 0-平台管理员, 1-租户管理员, 2-普通用户
	 * author chenfm
	 * createTime 2020/4/9 19:37
	 **/
	private Integer type;
	/**
	 * 创建用户
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 更新用户
	 */
	@TableField(fill = FieldFill.UPDATE)
	private String updateUser;
	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.UPDATE)
	private Date updateTime;
	/**
	 * 已删除
	 */
	@TableLogic
	private Boolean deleted;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
