package com.esv.datacenter.cc.module.menu.dto;

import lombok.Data;

import java.util.List;

@Data
public class MenuDTO {
    /**
     * 菜单id
     */
    private Long id;
    /**
     * 父菜单ID，一级菜单为0
     */
    private Long parentId;
    /**
     * 菜单编码
     */
    private String menuCode;
    /**
     * 上级名称
     */
    private String parentName;
    /**
     * 菜单名称
     */
    private String name;
    /**
     * 菜单URL
     */
    private String url;
    /**
     * 授权(多个用逗号分隔，如：user:list,user:create)
     */
    private String perms;
    /**
     * 类型   1：目录   2：菜单   3：按钮
     */
    private Integer type;
    /**
     * 菜单图标
     */
    private String icon;
    /**
     * 排序
     */
    private Integer orderNum;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;
    /**
     * 系统id
     */
    private Long systemId;
    /**
     * 菜单列表
     */
    private List<MenuDTO> children;

    /**
     * 字段唯一标识
     **/
    private String rowKey;

    /**
     * description 数据权限
     * author chenfm
     * createTime 2020/4/9 10:36
     **/
    private Integer dataPerm;

    /**
     * description 用户数据权限
     * author chenfm
     * createTime 2020/4/10 10:26
     **/
    private Integer userDataPerm;

    /**
     * 上级字段唯一标识
     **/
    private String parentRowKey;

    private Boolean available;

    public String getRowKey() {
        return id + "_" + type;
    }

}
