package com.esv.datacenter.cc.module.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.cc.module.user.entity.UserRoleEntity;

import java.util.List;

/**
 * 用户与角色对应关系
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
public interface UserRoleService extends IService<UserRoleEntity> {

    /**
     * description 编辑用户角色
     * param [userId, roleIdStr]
     * return void
     * author chenfm
     * createTime 2020/4/8 20:13
     **/
    void editUserRole(Long userId, String roleIdStr);

    /**
     * description 配置用户所有角色
     * param [userId, roleIdList, editUser]
     * return void
     * author chenfm
     * createTime 2020/3/17 16:16
     **/
    void saveUserRole(Long userId, List<Long> roleIdList);
    /**
     * 通过用户Id来查找对应的角色Id
     * @param userId 用户Id
     * @return 用户对应的角色Id
     */
    List<UserRoleEntity> listByUserId(long userId);

    /**
     * description 根据用户id删除
     * param [userId]
     * return void
     * author chenfm
     * createTime 2020/4/8 19:53
     **/
    void deleteByUserId(long userId);

    /**
     * description 通过角色id查询数量
     * param [roleId]
     * return int
     * author chenfm
     * createTime 2020/4/3 10:24
     **/
    int countByRoleId(long roleId);

    /**
     * description 用户是否具有超级管理员权限
     * param [userRoleList, roleId]
     * return boolean
     * author chenfm
     * createTime 2020/3/12 9:38
     **/
    boolean hasSuperAdminRole(long userId);

}

