package com.esv.datacenter.cc.module.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import com.esv.datacenter.cc.form.IdForm;
import com.esv.datacenter.cc.module.menu.service.MenuService;
import com.esv.datacenter.cc.module.system.dto.SystemDTO;
import com.esv.datacenter.cc.module.system.entity.SystemEntity;
import com.esv.datacenter.cc.module.system.form.SystemForm;
import com.esv.datacenter.cc.module.system.service.SystemService;
import com.esv.datacenter.cc.module.system.vo.SystemVO;
import com.esv.common.response.R;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @description： 系统应用维护Controller
 * @author：hcbmailbox@163.com
 * @date：2020/1/15
 */
@RestController
@RequestMapping("system")
@Slf4j
public class SystemController {

    private SystemService systemService;

    private MenuService menuService;

    @Autowired
    public SystemController(SystemService systemService, MenuService menuService) {
        this.systemService = systemService;
        this.menuService = menuService;
    }

    /**
     * description 查询未锁定系统
     * param []
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/18 11:03
     **/
    @GetMapping("listUnlock")
    public R listUnlock() {
        List<SystemEntity> systemEntityList = systemService.list();
        List<SystemVO> list = new ArrayList<>();
        systemEntityList.forEach(systemEntity -> {
            if (systemEntity.getStatus() == 0) {
                SystemVO systemVO = new SystemVO();
                BeanUtils.copyProperties(systemEntity, systemVO);
                list.add(systemVO);
            }
        });
        return R.ok(list);
    }

    /**
     * 查询所有应用
     * @return
     * @throws Exception
     */
    @GetMapping("list")
    public R list(@RequestParam(value = "current", defaultValue = "1") Integer current,
                  @RequestParam(value = "size", defaultValue = "10") Integer size,
                  @RequestParam(value = "systemName", required = false) String systemName,
                  @RequestParam(value = "status", required = false) Integer status) {
        IPage<SystemDTO> page = new Page<>(current, size);
        page = systemService.page(page, systemName, status);
        return R.ok(page);
    }

    /**
     * 创建应用
     * @param systemForm
     * @return
     */
    @PostMapping("create")
    public R create(@RequestBody @Validated(Add.class) SystemForm systemForm) {
        SystemEntity systemEntity = new SystemEntity();
        BeanUtils.copyProperties(systemForm, systemEntity);
        systemEntity.setStatus(0);
        systemService.save(systemEntity);
        return R.ok();
    }

    /**
     * 更新应用信息
     * @param systemForm
     * @return
     */
    @PostMapping("update")
    public R update(@RequestBody @Validated(Update.class) SystemForm systemForm) {
        SystemEntity systemEntity = systemService.getById(systemForm.getId());
        BeanUtils.copyProperties(systemForm, systemEntity);
        systemService.updateById(systemEntity);
        return R.ok();
    }

    /**
     * 删除应用
     * @param idForm
     * @return
     */
    @PostMapping("delete")
    public R delete(@RequestBody IdForm idForm) {
        Long id = idForm.getId();
        menuService.deleteBySystemId(id);
        systemService.removeById(id);
        return R.ok();
    }

}