package com.esv.datacenter.cc.module.role.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.cc.common.constants.Constant;
import com.esv.datacenter.cc.module.role.dao.RoleDao;
import com.esv.datacenter.cc.module.role.dto.RoleDTO;
import com.esv.datacenter.cc.module.role.dto.TenantRoleDTO;
import com.esv.datacenter.cc.module.role.entity.RoleEntity;
import com.esv.datacenter.cc.module.role.service.RoleService;
import com.esv.datacenter.cc.module.tenant.entity.TenantEntity;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("roleService")
public class RoleServiceImpl extends ServiceImpl<RoleDao, RoleEntity> implements RoleService {

    @Value("${app.prop.super-admin-role-id}")
    private String superAdminRoleId;

    @Override
    public Long createTenantAdminRole(TenantEntity tenantEntity) {
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setRoleName(tenantEntity.getTenantName() + "-租户管理员");
        roleEntity.setRemark("系统默认");
        roleEntity.setOrderNum(1);
        roleEntity.setTenantId(tenantEntity.getId());
        roleEntity.setDepartmentId(0L);
        roleEntity.setType(Constant.RoleType.TENANT_ADMIN.getValue());
        baseMapper.insert(roleEntity);
        return roleEntity.getId();
    }

    @Override
    public void listRoleDTOPage(IPage<RoleDTO> page, RoleDTO roleDTO) {
        baseMapper.listRoleDTOPage(page, roleDTO);
    }

    @Override
    public List<RoleEntity> listByTenantId(Long tenantId) {
        RoleEntity queryEntity = new RoleEntity();
        queryEntity.setTenantId(tenantId);
        QueryWrapper<RoleEntity> wrapper = new QueryWrapper<>(queryEntity);
        wrapper.orderByAsc("order_num");
        return list(wrapper);
    }

    @Override
    public void updateRoleCategory(long categoryId) {
        UpdateWrapper<RoleEntity> wrapper = new UpdateWrapper<>();
        wrapper.eq("category_id", categoryId);
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setCategoryId(0L);
        baseMapper.update(roleEntity, wrapper);
    }

    @Override
    public Boolean isSuperAdminRole(Long roleId) {
        return Long.parseLong(superAdminRoleId) == roleId;
    }

    @Override
    public Long getSuperAdminRoleId() {
        return Long.parseLong(superAdminRoleId);
    }

    @Override
    public List<TenantRoleDTO> allByTenant(Long tenantId, Integer type) {
        return baseMapper.allByTenant(tenantId, type);
    }

}
