package com.esv.datacenter.cc.module.role.form;

import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: esv-cc
 * @name: RoleForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/16 10:08
 * @version:1.0
 */
@Data
public class RoleForm {

    /**
     * description 角色id
     * author chenfm
     * createTime 2020/3/16 10:11
     **/
    @NotNull(groups = {Update.class}, message = "角色id不能为空")
    private Long id;
    /**
     * 角色名称
     */
    @NotNull(groups = {Add.class, Update.class}, message = "角色名称不能为空")
    private String roleName;
    /**
     * 备注
     */
    private String remark;
    /**
     * 排序
     */
    private Integer orderNum;
    /**
     * description 部门id
     * author chenfm
     * createTime 2020/4/3 13:56
     **/
    @NotNull(groups = {Add.class}, message = "租户id不能为空")
    private Long tenantId;
}
