package com.esv.datacenter.cc.module.department.form;

import com.esv.datacenter.cc.common.form.Delete;
import com.esv.datacenter.cc.common.form.Update;
import com.esv.datacenter.cc.common.form.Add;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @author chenfm
 */
@Data
public class DepartmentForm {
    @NotNull(groups = {Update.class, Delete.class}, message = "部门id不能为空")
    private Long id;
    /**
     * 部门名
     */
    @NotNull(groups = {Add.class, Update.class}, message = "部门名不能为空")
    @Length(groups = {Add.class, Update.class}, max = 50, message = "部门名长度不合法")
    private String departmentName;
    /**
     * 上级部门id
     */
    @NotNull(groups = {Add.class, Update.class}, message = "请选择上级部门")
    private String parentId;

    /**
     * 分类:1.集团/2.分公司/3.部门
     */
    private String category;
    /**
     * 负责人
     */
    @Length(groups = {Add.class, Update.class}, max = 50, message = "负责人长度不合法")
    private String principal;
    /**
     * 电话
     */
    @Length(groups = {Add.class, Update.class}, max = 50, message = "电话长度不合法")
    private String phone;
    /**
     * 备注
     */
    @Length(groups = {Add.class, Update.class}, max = 500, message = "备注长度不合法")
    private String remark;
    /**
     * 排序
     */
    @NotNull(groups = {Add.class, Update.class}, message = "显示排序值不能为空")
    private int orderNum;

}
