package com.esv.datacenter.cc.module.tenant.form;

import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/11 11:09
 * @version:1.0
 */
@Data
public class TenantForm {
    /**
     * 租户id
     */
    @NotNull(groups = {Update.class}, message = "租户id不能为空")
    private Long id;
    /**
     * 租户名
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "租户名不能为空")
    private String tenantName;
    /**
     * 租户代码
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "租户代码不能为空")
    private String tenantCode;
    /**
     * 联系人姓名
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "联系人姓名不能为空")
    private String contact;
    /**
     * 联系人电话
     */
    @NotBlank(groups = {Add.class, Update.class}, message = "联系人电话不能为空")
    private String contactPhone;
    /**
     * 状态  0:正常/1:锁定
     */
    @NotNull(groups = {Add.class, Update.class}, message = "状态不能为空")
    private Integer status;
}
