package com.esv.datacenter.cc.module.department.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.cc.module.department.entity.DepartmentEntity;
import com.esv.datacenter.cc.module.department.vo.DepartmentChooseVO;
import com.esv.datacenter.cc.module.department.vo.DepartmentInfoVO;
import com.esv.datacenter.cc.module.department.vo.DepartmentVO;

import java.util.List;

/**
 * @description:
 * @project: cc
 * @name: DepartmentService
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/4 15:01
 * @version:1.0
 */
public interface DepartmentService extends IService<DepartmentEntity> {
    /**
     * description 查询所有部门树列表
     * param [parentId, departmentName]
     * return java.util.List<DepartmentDTO>
     * author chenfm
     * createTime 2020/3/10 9:13
     **/
    List<DepartmentVO> listDepartmentTree(long tenantId, long parentId, String departmentName);

    /**
     * description 查询部门详细信息
     * param [departmentId]
     * return DepartmentInfoVO
     * author chenfm
     * createTime 2020/3/17 13:52
     **/
    DepartmentInfoVO departmentInfo(Long departmentId);

    /**
     * description 查询上级部门名称列表
     * param [departmentId]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/10 9:15
     **/
    List<String> getParentNameList(long departmentId);

    /**
     * description 删除部门及下属所有部门
     * param [departmentId]
     * return void
     * author chenfm
     * createTime 2020/3/10 9:15
     **/
    void deleteById(long departmentId);

    /**
     * description 查询可修改上级组织
     * param [departmentId, parentId]
     * return java.util.List<DepartmentChooseVO>
     * author chenfm
     * createTime 2020/3/10 9:15
     **/
    List<DepartmentChooseVO> chooseList(Long tenantId, Long parentId, String departmentId);

    /**
     * description 处理可选部门
     * param [departmentId, departmentVO]
     * return com.esv.cc.module.department.vo.DepartmentChooseVO
     * author chenfm
     * createTime 2020/4/4 16:15
     **/
    DepartmentChooseVO makeChooseVO(String departmentId, DepartmentVO departmentVO);

    /**
     * description 查询当前及所有下属组织id
     * param [departmentIdList, departmentId]
     * return void
     * author chenfm
     * createTime 2020/4/4 16:18
     **/
    void findCurrentAndChildrenId(List<Long> departmentIdList, Long departmentId);
}

