package com.esv.datacenter.cc.module.user.dao;

import com.esv.datacenter.cc.module.user.entity.UserRoleEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 用户与角色对应关系
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Mapper
public interface UserRoleDao extends BaseMapper<UserRoleEntity> {
    /**
     * 通过用户Id来查找对应的角色Id
     * @param userId 用户Id
     * @return 用户对应的角色Id
     */
    List<UserRoleEntity> listByUserId(long userId);
}
