package com.esv.datacenter.cc.module.user.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.esv.datacenter.cc.module.user.dto.UserDTO;
import com.esv.datacenter.cc.module.user.entity.UserEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.Map;

/**
 * 系统用户
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Mapper
public interface UserDao extends BaseMapper<UserEntity> {

    /**
     * 通过用户id查询用户信息（含角色id）
     * @param id
     * @return
     */
    UserEntity selectUserInfoById(Long id);

    /**
     * 查询用户详情
     * @param queryObj
     * @return
     */
    UserDTO selectUserDetailInfo(Map<String, Object> queryObj);

    /**
     * 查询用户列表（含角色id）
     * @param page
     * @param queryObj
     * @return
     */
    IPage selectUserList(IPage page, Map<String, Object> queryObj);

}
