package com.esv.datacenter.cc.module.system.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.cc.module.account.dto.UserSystemDTO;
import com.esv.datacenter.cc.module.system.dto.SystemDTO;
import com.esv.datacenter.cc.module.system.entity.SystemEntity;

import java.util.List;

/**
 * 系统应用表
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
public interface SystemService extends IService<SystemEntity> {

    /**
     * 查询所有系统应用
     * @return
     */
    IPage<SystemDTO> page(IPage page, String systemName, Integer status);

    /**
     * description 根据code查询系统信息
     * param [code]
     * return SystemEntity
     * author chenfm
     * createTime 2020/3/24 15:22
     **/
    SystemEntity getByCode(String code);

    /**
     * 查询用户可用系统
     * @param userId
     * @return
     */
    List<UserSystemDTO> userSystemList(Long tenantId, Long userId);

}

