package com.esv.datacenter.cc.module.system.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Date;

/**
 * 系统应用表
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Data
@TableName("cc_system")
public class SystemEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 系统id
	 */
	@TableId
	private Long id;
	/**
	 * 系统标识编码
	 */
	private String systemCode;
	/**
	 * 系统名称
	 */
	private String systemName;
	/**
	 * 系统图标
	 */
	private String icon;
	/**
	 * 系统url
	 */
	private String url;
	/**
	 * 开发url
	 */
	private String devUrl;
	/**
	 * 状态  0:正常/1:锁定
	 */
	private Integer status;
	/**
	 * 创建用户
	 */
	private String createUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 更新用户
	 */
	private String updateUser;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	/**
	 * 已删除
	 */
	@TableLogic
	private Boolean deleted;

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
	}

}
