package com.esv.datacenter.cc.module.role.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@Data
public class RoleDTO {
    /**
     * 角色id
     */
    private Long id;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 备注
     */
    private String remark;
    /**
     * 排序
     */
    private Integer orderNum;
    /**
     * 类别id
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long categoryId;
    /**
     * description 角色类型: 0-平台管理角色, 1-租户管理角色, 2-普通角色
     * author chenfm
     * createTime 2020/4/9 9:30
     **/
    private Integer type;
    /**
     * 类别名称
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String categoryName;
    /**
     * description 租户id
     * author chenfm
     * createTime 2020/3/16 9:59
     **/
    private Long tenantId;
    /**
     * description 部门id
     * author chenfm
     * createTime 2020/4/1 17:19
     **/
    private Long departmentId;
    /**
     * description 租户名称
     * author chenfm
     * createTime 2020/3/16 10:00
     **/
    private String tenantName;
    /**
     * description 部门名称
     * author chenfm
     * createTime 2020/4/3 9:59
     **/
    private String departmentName;
    /**
     * 可被删除
     */
    private Boolean canEdited;
}
