package com.esv.datacenter.cc.module.role.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.esv.datacenter.cc.common.form.Add;
import com.esv.datacenter.cc.common.form.Update;
import com.esv.datacenter.cc.form.IdForm;
import com.esv.datacenter.cc.module.role.dto.RoleCategoryDTO;
import com.esv.datacenter.cc.module.role.entity.RoleCategoryEntity;
import com.esv.datacenter.cc.module.role.form.RoleCategoryForm;
import com.esv.datacenter.cc.module.role.service.RoleCategoryService;
import com.esv.datacenter.cc.module.role.service.RoleService;
import com.esv.common.response.R;
import com.esv.gateway.common.GatewayHeaders;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 角色分类
 */
@Slf4j
@RestController
@RequestMapping("roleCategory")
public class RoleCategoryController {

    private RoleCategoryService roleCategoryService;

    private RoleService roleService;

    @Autowired
    public RoleCategoryController(RoleCategoryService roleCategoryService, RoleService roleService) {
        this.roleCategoryService = roleCategoryService;
        this.roleService = roleService;
    }

    /**
     * @description 查询所有角色分类
     * param [tenantId]
     * @return com.esv.common.response.R
     * @author chenfm
     * @createTime 2020/3/11 10:13
     **/
    @GetMapping("list")
    public R list(@RequestHeader(GatewayHeaders.TENANT_ID) Long tenantId) {
        QueryWrapper<RoleCategoryEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("tenant_id", tenantId);
        wrapper.orderByAsc("order_num");
        List<RoleCategoryEntity> list = roleCategoryService.list(wrapper);
        return R.ok(list);
    }

    /**
     * @description 查询所有角色分类及角色
     * param [tenantId]
     * @return com.esv.common.response.R
     * @author chenfm
     * @createTime 2020/3/11 10:14
     **/
    @GetMapping("listWithRole")
    public R listCategoryWithRole(@RequestHeader(GatewayHeaders.TENANT_ID) Long tenantId) {
        List<RoleCategoryDTO> list = roleCategoryService.listAllRoleCategory(tenantId);
        return R.ok(list);
    }

    /**
     * @description 添加角色分类
     * param [userId, roleCategoryEntity]
     * @return com.esv.common.response.R
     * @author chenfm
     * @createTime 2020/3/11 10:14
     **/
    @PostMapping("add")
    public R add(
            @RequestHeader(GatewayHeaders.TENANT_ID) Long tenantId,
            @RequestBody @Validated(Add.class) RoleCategoryForm roleCategoryForm) {
        RoleCategoryEntity roleCategoryEntity = new RoleCategoryEntity();
        BeanUtils.copyProperties(roleCategoryForm, roleCategoryEntity);
        roleCategoryEntity.setTenantId(tenantId);
        roleCategoryService.save(roleCategoryEntity);
        return R.ok();
    }

    /**
     * description 修改角色类别
     * param [userId, roleCategoryEntity]
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/13 18:10
     **/
    @PostMapping("update")
    public R update(@RequestBody @Validated(Update.class) RoleCategoryForm roleCategoryForm) {
        RoleCategoryEntity roleCategoryEntity = new RoleCategoryEntity();
        BeanUtils.copyProperties(roleCategoryForm, roleCategoryEntity);
        roleCategoryService.updateById(roleCategoryEntity);
        return R.ok();
    }

    /**
     * description 删除角色类别
     * param [idForm]
     * return com.esv.common.response.R
     * author chenfm
     * createTime 2020/3/13 18:10
     **/
    @Transactional
    @PostMapping("delete")
    public R delete(@RequestBody @Validated IdForm idForm) {
        roleService.updateRoleCategory(idForm.getId());
        roleCategoryService.removeById(idForm.getId());
        return R.ok();
    }

}
