package com.esv.datacenter.cc.module.tenant.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

/**
 * @description:
 * @project: esv-cc
 * @name: TenantVO
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/11 10:27
 * @version:1.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Data
public class TenantVO {
    /**
     * 租户id
     */
    private Long id;
    /**
     * 租户名
     */
    private String tenantName;
    /**
     * 租户代码
     */
    private String tenantCode;
    /**
     * 联系人姓名
     */
    private String contact;
    /**
     * 联系人电话
     */
    private String contactPhone;
    /**
     * 状态  0:正常/1:锁定
     */
    private Integer status;

    /**
     * description 管理角色id
     * author chenfm
     * createTime 2020/4/1 17:48
     **/
    private Long adminRoleId;

    public TenantVO() {

    }

    public TenantVO(Long id, String tenantName) {
        this.id = id;
        this.tenantName = tenantName;
    }

}
